<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\DbLogBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormError;
use Lexik\Bundle\FormFilterBundle\Filter\Form\Type as Filters;

/**
 * Class LogFilterType
 * @package LifeStyle\Tools\DbLogBundle\Form
 */
class LogFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('level', Filters\NumberFilterType::class)
            ->add('channel', Filters\TextFilterType::class)
            ->add('extras', Filters\TextFilterType::class, array('label' => 'Extras'));

        $listener = function (FormEvent $event) {

            // Is data empty?
            if ($this->isEmpty($event->getData())) {
                $event->getForm()->addError(new FormError('Filter empty'));
            }
        };
        $builder->addEventListener(FormEvents::POST_SUBMIT, $listener);
    }

    /**
     * @param array|null $data
     * @return bool
     */
    private function isEmpty($data)
    {
        if (is_array($data)) {
            foreach ($data as $value) {
                if (!$this->isEmpty($value)) {
                    return false;
                }
            }
            return true;
        }
        return empty($data);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_dblog';
    }
}
