<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\ORMHelperBundle\Helper;

use \Doctrine\ORM\Id\AbstractIdGenerator;

/**
 * Class IdGenerator
 * @package LifeStyle\Tools\ORMHelperBundle\Helper
 */
class IdGenerator extends AbstractIdGenerator
{
    /**
     * @param \Doctrine\ORM\EntityManager $em
     * @param \Doctrine\ORM\Mapping\Entity $entity
     * @return mixed|string
     */
    public function generate(\Doctrine\ORM\EntityManager $em, $entity)
    {
        return base_convert(hash('crc32', microtime() . '#' . mt_rand()), 16, 36);
    }
}
