<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\WebserviceBundle\Configuration;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\ConfigurationAnnotation;
use LifeStyle\Tools\WebserviceBundle\Event\Credentials;

/**
 * Webservice security configuration
 *
 * @Annotation
 */
class WsSecurity extends ConfigurationAnnotation
{

    /**
     * List of security tests
     *
     * @var array
     */
    protected $tests;

    /**
     * Get list of security test
     *
     * @return array
     */
    public function getTests()
    {
        return $this->tests;
    }

    /**
     * Set security tests
     *
     * @param array|string $tests
     */
    public function setTests($tests)
    {
        $this->tests = Credentials::convertConfigurationAnnotation(is_array($tests) ? $tests : array($tests));
    }

    /**
     * Set value
     *
     * @param array|string $tests
     */
    public function setValue($tests)
    {
        $this->setTests($tests);
    }

    /**
     * Returns the annotation alias name.
     *
     * @return string
     * @see ConfigurationInterface
     */
    public function getAliasName()
    {
        return 'wsSecurity';
    }

    /**
     * Only one validation is allowed
     *
     * @return bool
     * @see ConfigurationInterface
     */
    public function allowArray()
    {
        return false;
    }

}
