<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\WebserviceBundle\Error\Type;

use Psr\Log\LogLevel;

/**
 * Class Internal
 * @package LifeStyle\Tools\WebserviceBundle\Error\Type
 */
class Internal extends Base
{

    /**
     *
     * @var Exception
     */
    protected $_exception;

    /**
     *
     * @param string $errorRef
     * @param string $errorCode
     * @param string $shortMessage
     * @param string $longMessage
     * @param \Exception $exception
     */
    public function __construct(
        $errorRef,
        $errorCode = '',
        $shortMessage = '',
        $longMessage = '',
        \Exception $exception = null
    ) {
        $this->_exception = $exception;
        parent::__construct($errorRef, $errorCode, $shortMessage, $longMessage);
    }

    /**
     * Get type of this error
     *
     * @return string
     */
    public function getErrorType()
    {
        return 'internal';
    }

    /**
     * Get error priority
     *
     * @see Psr\Log\LogLevel\LogLevel
     * @return int
     */
    protected function _getLogPriority()
    {
        return LogLevel::CRITICAL;
    }

    /**
     * Get log message
     *
     * @return string
     */
    protected function _getLogMessage()
    {
        $lineDelemiter = PHP_EOL . str_repeat(' ', 35);
        return parent::_getLogMessage() . $lineDelemiter
            . 'Application Error' . $lineDelemiter
            . 'Code: ' . $this->_exception->getCode() . $lineDelemiter
            . 'File: ' . $this->_exception->getFile() . $lineDelemiter
            . 'Line: ' . $this->_exception->getLine() . $lineDelemiter
            . 'Message: ' . $this->_exception->getMessage() . $lineDelemiter
            . 'Stacktrace: ' . $lineDelemiter
            . str_replace(PHP_EOL, $lineDelemiter, $this->_exception->getTraceAsString());
    }

    /**
     *
     * @param string $errorCode
     * @param string $shortMessage
     * @param string $longMessage
     */
    protected function codeToMessage(&$errorCode, &$shortMessage, &$longMessage)
    {
        switch ($errorCode) {
            case 'ApiError':
                $longMessage = $shortMessage;
                $shortMessage = 'Internal error';
                $errorCode = 'api1';
                break;
            case 'CriticalError':
                $longMessage = $shortMessage;
                $shortMessage = 'Internal error';
                $errorCode = 'crit1';
                break;
        }
    }

}
