<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\XmlBundle\Library\Xml;

/**
 * Class Document
 * @package LifeStyle\Tools\XmlBundle\Library\Xml
 */
class Document extends \DOMDocument
{

    /**
     * Create new text element
     *
     * @param string $name The tag name of the element.
     * @param string $value The value of the element. Value will be escaped.
     * @return \DOMElement a new instance of class <b>DOMElement</b> or <b>FALSE</b> if an error occurred.
     */
    public function createTextElement($name, $value)
    {
        if (!($element = $this->createElement($name))) {
            return $element;
        }
        $textNode = $this->createTextNode($value);
        $element->appendChild($textNode);

        return $element;
    }

    /**
     * Create new bool element
     *
     * @param string $name The tag name of the element.
     * @param bool|int $value The value of the element. Value will treated as boolean.
     * @return \DOMElement a new instance of class <b>DOMElement</b> or <b>FALSE</b> if an error occurred.
     */
    public function createBoolElement($name, $value)
    {
        return $this->createElement($name, $value ? '1' : '0');
    }

    /**
     * Create new bool element
     *
     * @param string $name The tag name of the element.
     * @param string|int $value The value of the element. Value will treated as date.
     * @return \DOMElement a new instance of class <b>DOMElement</b> or <b>FALSE</b> if an error occurred.
     */
    public function createDateTimeElement($name, $value)
    {
        return $this->createElement($name, $value);
    }

    /**
     * Create new CDATA element
     *
     * @param string $name The tag name of the element.
     * @param string $value The value of the element. Value will be published as CDATA-section.
     * @return \DOMElement a new instance of class <b>DOMElement</b> or <b>FALSE</b> if an error occurred.
     */
    public function createCDATAElement($name, $value)
    {
        if (!($element = $this->createElement($name))) {
            return $element;
        }
        $cdataSection = $this->createCDATASection($value);
        $element->appendChild($cdataSection);

        return $element;
    }

    /**
     * Change node name
     *
     * @param \DOMElement $node
     * @param string $name
     * @return \DOMElement
     */
    public function setNodeName($node, $name)
    {
        // No changes made
        if ($node->nodeName == $name) {
            return;
        }
        $newnode = $this->createElement($name);
        foreach ($node->childNodes as $child) {
            $child = $this->importNode($child, true);
            $newnode->appendChild($child, true);
        }
        foreach ($node->attributes as $attrName => $attrNode) {
            $newnode->setAttribute($attrName, $attrNode);
        }
        $this->replaceChild($newnode, $node);
        return $newnode;
    }
}
