<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\AccessBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class AccessLog
 * @package Sso\AccessBundle\Entity
 *
 * @ORM\Table(name="webservice_access_log")
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 */
class AccessLog
{
    /**
     * @ORM\Column(type="guid", name="id")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="UUID")
     * @var string
     */
    private $id;

    /**
     * @ORM\Column(name="username", type="string", length=255, nullable=false)
     * @var string
     */
    private $username;

    /**
     * @ORM\Column(name="token", type="string", length=255, nullable=true)
     * @var string
     */
    private $token;

    /**
     * @ORM\Column( type="array" )
     * @var array
     */
    private $services = [];

    /**
     * @ORM\Column(name="created_at", type="datetime", nullable=false)
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @ORM\Column(name="updated_at", type="datetime", nullable=false)
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * AccessLog constructor.
     */
    public function __construct()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return AccessLog
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * @param string $token
     */
    public function setToken($token)
    {
        $this->token = $token;
    }

    /**
     * @return mixed
     */
    public function getServices()
    {
        return $this->services;
    }

    /**
     * @param array $services
     */
    public function setServices(array $services)
    {
        if (!empty($services) && $services === $this->services) {
            reset($services);
            $services[key($services)] = clone current($services);
        }
        $this->services = $services;
    }

    /**
     * @param string $serviceName
     */
    public function addService($serviceName)
    {
        if (!key_exists($serviceName, $this->services)) {
            $this->services[$serviceName] = $serviceName;
        }
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @ORM\PreUpdate
     */
    public function setUpdatedAt()
    {
        $this->updatedAt = new \DateTime();
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
}
