<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Api\Configuration;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class IndexConfiguration
 * @package Sso\ApiBundle\Api\Configuration
 */
class IndexConfiguration
{
    /**
     * @var Container
     */
    public $container;

    /**
     *
     * @param \Symfony\Component\DependencyInjection\ContainerInterface $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @param string $confParam
     * @return string
     */
    public function getParam($confParam)
    {
        return $this->container->getParameter($confParam);
    }
}
