<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Api\Debug;

use Symfony\Component\Stopwatch\Stopwatch as BaseStopWatch;

class StopWatch
{
    protected $stopWatch;

    public function __construct(BaseStopWatch $stopWatch)
    {
        $this->stopWatch = $stopWatch;
    }

    public function start($id)
    {
        if ($this->stopWatch) {
            $this->stopWatch->start($id);
        }
    }

    public function stop($id)
    {
        if ($this->stopWatch) {
            $this->stopWatch->stop($id);
        }
    }
}
