<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Api\Error\Type;

/**
 * Class External
 * @package Sso\ApiBundle\Api\Error\Type
 */
class External extends Base
{
    /**
     * Get type of this error
     *
     * @return string
     */
    public function getErrorType()
    {
        return 'external';
    }

    /**
     *
     * @param string $errorCode
     * @param string $shortMessage
     * @param string $longMessage
     */
    protected function codeToMessage(&$errorCode, &$shortMessage, &$longMessage)
    {
        switch ($errorCode) {
            case 'InvalidRemoteAddress':
                $longMessage = $shortMessage;
                $shortMessage = 'Invalid remote address';
                $errorCode = 'h000';
                break;
            case 'XmlInvalid':
                $longMessage = $shortMessage;
                $shortMessage = 'Invalid xml';
                $errorCode = 'x000';
                break;
            case 'ControllerNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Cannot retrieve controller name from xml';
                $shortMessage = 'Invalid controller';
                $errorCode = 'x001';
                break;
            case 'ActionNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Cannot retrieve action name from xml';
                $shortMessage = 'Invalid action';
                $errorCode = 'x002';
                break;
            case 'ControllerInvalid':
                $longMessage = $shortMessage ? $shortMessage : 'Check the manual for valid controllers';
                $shortMessage = 'Invalid controller';
                $errorCode = 'x003';
                break;
            case 'ActionInvalid':
                $longMessage = $shortMessage ? $shortMessage : 'Action not allowed in current controller. Check the manual for valid actions';
                $shortMessage = 'Invalid action';
                $errorCode = 'x004';
                break;
            case 'xmlElementInvalid':
                $longMessage = $shortMessage ? $shortMessage : 'Xml-element is not allowed in this context';
                $shortMessage = 'Invalid xml-element';
                $errorCode = 'x005';
                break;
            case 'xmlElementCount':
                $longMessage = $shortMessage ? $shortMessage : 'Check number of allowed xml-elements';
                $shortMessage = 'Invalid number of xml-elements';
                $errorCode = 'x006';
                break;
            case 'xmlElementNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Required xml-element not found';
                $shortMessage = 'Missing xml-element';
                $errorCode = 'x007';
                break;
            case 'CredentialsNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Missing credential nodes in xml. Check your xml';
                $shortMessage = 'Missing credentials';
                $errorCode = 'x008';
                break;
            case 'CredentialsXml':
                $longMessage = $shortMessage ? $shortMessage : 'Invalid xml structure. See errors below';
                $shortMessage = 'Credentials error';
                $errorCode = 'c001';
                break;
            case 'CredentialsController':
                $longMessage = $shortMessage ? $shortMessage : 'Controller Name seems to be empty';
                $shortMessage = 'Credentials error';
                $errorCode = 'c002';
                break;
            case 'CredentialsRemoteAddress':
                $longMessage = $shortMessage ? $shortMessage : 'Remote Address seems to be empty';
                $shortMessage = 'Credentials error';
                $errorCode = 'c003';
                break;
            case 'CredentialsAction':
                $longMessage = $shortMessage ? $shortMessage : 'Controller Action seems to be empty';
                $shortMessage = 'Credentials error';
                $errorCode = 'c004';
                break;
            case 'CredentialsToken':
                $longMessage = $shortMessage ? $shortMessage : 'Invalid service token';
                $shortMessage = 'Credentials error';
                $errorCode = 'c005';
                break;
            case 'CredentialsIp':
                $longMessage = $shortMessage ? $shortMessage : 'Invalid ip address';
                $shortMessage = 'Credentials error';
                $errorCode = 'c006';
                break;
            case 'CredentialsPermissions':
                $longMessage = $shortMessage ? $shortMessage : 'Token has no permissions to do this request';
                $shortMessage = 'Credentials error';
                $errorCode = 'c007';
                break;
            case 'CredentialsUser':
                $longMessage = $shortMessage;
                $shortMessage = 'Invalid user identifier';
                $errorCode = 'c008';
                break;
            case 'UserNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'User not found in database';
                $shortMessage = 'Invalid user';
                $errorCode = 'u001';
                break;
            case 'UserApplicationNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'User not linked to application';
                $shortMessage = 'Invalid user application';
                $errorCode = 'u002';
                break;
            case 'UserApplicationExists':
                $longMessage = $shortMessage ? $shortMessage : 'User already linked to application';
                $shortMessage = 'Invalid user application';
                $errorCode = 'u003';
                break;
            case 'UserApplicationAttributeMultiple':
                $longMessage = $shortMessage ? $shortMessage : 'Attribute is not a multi-value and may not be set more than once in a request';
                $shortMessage = 'Mutliple attribute';
                $errorCode = 'u004';
                break;
            case 'UserTokenExpired':
                $longMessage = $shortMessage ? $shortMessage : 'Token has expired';
                $shortMessage = 'Invalid token';
                $errorCode = 'u005';
                break;
            case 'UserApplicationAttributeNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Attribute not found in database';
                $shortMessage = 'Invalid attribute';
                $errorCode = 'u006';
                break;
            case 'UserTokenNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'User not found in database or password-token has expired';
                $shortMessage = 'Invalid token';
                $errorCode = 'u007';
                break;
            case 'UserApplicationRoleNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'User not linked to application role';
                $shortMessage = 'Invalid role';
                $errorCode = 'u008';
                break;
            case 'UserIsActive':
                $longMessage = $shortMessage ? $shortMessage : 'User is already active. There is no need, to activeate user again';
                $shortMessage = 'User active';
                $errorCode = 'u009';
                break;
            case 'UserActivateTokenNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'User not found in database or activation-token has expired';
                $shortMessage = 'Invalid token';
                $errorCode = 'u010';
                break;
            case 'ApplicationNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Application not found in database';
                $shortMessage = 'Invalid application';
                $errorCode = 'a001';
                break;
            case 'ApplicationRoleNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Role does not exist in application';
                $shortMessage = 'Invalid application role';
                $errorCode = 'a002';
                break;
            case 'AttributeExists':
                $longMessage = $shortMessage ? $shortMessage : 'Attribute already exists in database';
                $shortMessage = 'Invalid attribute';
                $errorCode = 'at001';
                break;
            case 'AttributeNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Attribute not found in database';
                $shortMessage = 'Invalid attribute';
                $errorCode = 'at002';
                break;
            case 'RoleExists':
                $longMessage = $shortMessage ? $shortMessage : 'Role already exists in database';
                $shortMessage = 'Invalid role';
                $errorCode = 'ar001';
                break;
            case 'RoleNotFound':
                $longMessage = $shortMessage ? $shortMessage : 'Role not found in database';
                $shortMessage = 'Invalid role';
                $errorCode = 'ar002';
                break;
            default:
                // Do not modify unlisted error message, because validation error messages should not be changed
                $longMessage = $longMessage ? $longMessage : 'Unknown error (' . $errorCode . ')';
                $shortMessage = $shortMessage ? $shortMessage : 'Unknown error';
                break;
        }
    }
}
