<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Api\Form;

use Sso\ApiBundle\Api;

/**
 * Class Index
 * @package Sso\ApiBundle\Api\Form
 */
class Index
{
    /**
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     *
     * @return array
     */
    public function getCountryIds()
    {
        $countryEntities = $this->apiM->database()->webservice()->country()->getCountryRepository()->findAll();
        $resultsArray = array();
        foreach ($countryEntities as $countryEntity) {
            $countryCode = $countryEntity->getCode();
            $countryName = $countryEntity->getName();
            //set it
            $resultsArray[$countryCode] = $countryName;
        }

        return $resultsArray;
    }

    /**
     *
     * @return array
     */
    public function getLanguageIds()
    {
        $langEntities = $this->apiM->database()->webservice()->language()->getLanguageRepository()->findAll();

        $resultsArray = array();
        foreach ($langEntities as $langEntity) {
            $langId = $langEntity->getId();
            $langName = $langEntity->getName();
            //set it
            $resultsArray[$langId] = $langName;
        }

        asort($resultsArray);
        return $resultsArray;
    }

    public function getTimezoneIds()
    {
        $tzEntities = $this->apiM->database()->webservice()->timezone()->getTimezoneRepository()->findAll();
        $resultsArray = array();
        foreach ($tzEntities as $tzEntity) {
            $tzId = $tzEntity->getId();
            $tzName = $tzEntity->getName();
            //set it
            $resultsArray[$tzId] = $tzName;
        }
        asort($resultsArray);
        return $resultsArray;
    }
}
