<?php

/**
 * User: sb
 * Date: 07.04.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Api;

use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Sso\ApiBundle\Database\Manager as DatabaseManager;
use LifeStyle\Tools\WebserviceBundle\Response\Builder as ResponseBuilder;

/**
 * Class Manager
 * @package Sso\ApiBundle\Api
 */
class Manager
{
    /**
     * @var LoggerInterface
     */
    public $logger;

    /**
     * @var Container
     */
    public $container;

    /**
     *
     * @var DatabaseManager
     */
    protected $_databaseManager;

    /**
     * List of api managers
     *
     * @var array
     */
    protected $apiSetter;

    public function __construct(Container $container, LoggerInterface $logger)
    {
        $this->logger = $logger;
        $this->container = $container;
    }

    /**
     * @return Logger\Index
     */
    public function logger()
    {

        if (!isset($this->apiSetter['logger'])) {
            $this->apiSetter['logger'] = new Logger\Index($this->logger);
        }

        return $this->apiSetter['logger'];
    }

    /**
     * @return Mail\IndexMail
     */
    public function mail()
    {
        if (!isset($this->apiSetter['mail'])) {
            $this->apiSetter['mail'] = new Mail\IndexMail();
        }

        return $this->apiSetter['mail'];
    }

    /**
     * @return Configuration\IndexConfiguration
     */
    public function configuration()
    {
        if (!isset($this->apiSetter['configuration'])) {
            $this->apiSetter['configuration'] = new Configuration\IndexConfiguration($this->container);
        }

        return $this->apiSetter['configuration'];
    }

    /**
     * @return \Symfony\Component\Validator\Validator\LegacyValidator
     */
    public function validator()
    {
        return $this->container->get('validator');
    }

    /**
     *
     * @return \Symfony\Component\HttpKernel\Profiler\Profiler
     */
    public function profiler()
    {
        return $this->container->has('profiler') ? $this->container->get('profiler') : null;
    }

    /**
     * @return Controller\IndexController
     */
    public function controller()
    {
        if (!isset($this->apiSetter['controller'])) {
            $this->apiSetter['controller'] = new Controller\IndexController($this);
        }

        return $this->apiSetter['controller'];
    }

    /**
     * @return Credentials\Index
     */
    public function credentials()
    {
        if (!isset($this->apiSetter['credentials'])) {
            $this->apiSetter['credentials'] = new Credentials\Index($this);
        }

        return $this->apiSetter['credentials'];
    }

    /**
     * @return Importer\Index
     */
    public function importer()
    {
        if (!isset($this->apiSetter['importer'])) {
            $this->apiSetter['importer'] = new Importer\Index($this);
        }

        return $this->apiSetter['importer'];
    }

    /**
     * @return Translator\Factory
     */
    public function translator()
    {
        if (!isset($this->apiSetter['translator'])) {
            $this->apiSetter['translator'] = new Translator\Factory($this);
        }

        return $this->apiSetter['translator'];
    }

    /**
     * @return Form\Index
     */
    public function form()
    {
        if (!isset($this->apiSetter['form'])) {
            $this->apiSetter['form'] = new Form\Index($this);
        }

        return $this->apiSetter['form'];
    }

    /**
     * @return Mapper\Index
     */
    public function mapper()
    {
        if (!isset($this->apiSetter['mapper'])) {
            $this->apiSetter['mapper'] = new Mapper\Index($this);
        }

        return $this->apiSetter['mapper'];
    }

    /**
     * Database manager
     *
     * @return DatabaseManager
     */
    public function database()
    {
        return null !== $this->_databaseManager ? $this->_databaseManager : ($this->_databaseManager = new DatabaseManager($this->container->get('doctrine'),
            $this->container->get('validator')));
    }

    /**
     * Xml Response Builder
     *
     * @return ResponseBuilder
     */
    public function responseBuilder()
    {
        return $this->container->get('lifestyle.webservice.response.builder');
    }

    /**
     * Error storage
     *
     * @return \LifeStyle\Tools\WebserviceBundle\Error\Storage
     */
    public function errors()
    {
        return $this->container->get('lifestyle.webservice.error.storage');
    }

    /**
     * JMS Serializer
     *
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }

    /**
     * Start stopwatch
     *
     * @return \Symfony\Component\Stopwatch\Stopwatch
     */
    public function getStopwatch()
    {
        return $this->container->get('debug.stopwatch');
    }

    /**
     * Start stopwatch
     *
     * @param string $id
     */
    public function startStopwatch($id)
    {
        if ($this->container->has('debug.stopwatch')) {
            $this->container->get('debug.stopwatch')->start($id);
        }
    }

    /**
     * Stop stopwatch
     *
     * @param string $id
     * @return int Duration in ms
     */
    public function stopStopwatch($id)
    {
        if ($this->container->has('debug.stopwatch')) {
            return $this->container->get('debug.stopwatch')->stop($id)->getDuration();
        }
        return 0;
    }

    /**
     * @return Container
     */
    public function getContainer()
    {
        return $this->container;
    }
}
