<?php

/**
 * User: sb
 * Date: 17.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Api\Translator;

use Sso\ApiBundle\Api;
use Symfony\Component\Intl\Locale\Locale;
use Symfony\Component\Intl\Intl;

class Country
{

    /**
     *
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     *
     * @param string $displayLocale e.g. ('en','ja'...)
     * @return array
     */
    public function getCountryCodes()
    {
        $countryCodesTemp = Intl::getRegionBundle()->getCountryNames();

        $countryCodes = array();
        foreach ($countryCodesTemp as $code => $value) {
            $countryCodes[] = $code;
        }

        return $countryCodes;
    }


    /**
     *
     * @param string $displayLocale e.g. ('en','ja'...)
     * @return array
     */
    public function getCountryNames($displayLocale = 'en')
    {
        $localeObject = new Locale();
        $localeObject->setDefault($displayLocale);
        $countries = Intl::getRegionBundle()->getCountryNames();

        return $countries;
    }

    /**
     * Returns the name of a country.
     *
     * @param string $country A country code (e.g. "US").
     * @param string $displayLocale Optional. The locale to return the name in.
     *                        Defaults to {@link \Locale::getDefault()}.
     *
     * @return string|null The name of the country or NULL if not found.
     */
    public function getCountryName($country, $displayLocale = 'en')
    {
        $countryName = Intl::getRegionBundle()->getCountryName($country, $displayLocale);

        return $countryName;
    }
}
