<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Sso\ApiBundle\Entity\Webservice\Type;
use Sso\ApiBundle\Api;
use Sso\Webservices\LocationBundle\Entity\Timezone as ModelTimezone;

/**
 * User application database handler
 */
class Timezone extends Base
{

    /**
     * ISO 632.2 en
     * @param \Sso\ApiBundle\Api\Manager $apiM
     * @return boolean
     */
    public function fillTimezoneWithDefaultData(Api\Manager $apiM)
    {

        // we need a language entity to add it default lan is en

        $langEntity = $apiM->database()->webservice()->language()->getLanguageRepository()->find('en');

        if (empty($langEntity)) {
            return false;
        }

        $timezoneArray = $apiM->translator()->timezones()->getTimezones();

        // now we set all languages 
        foreach ($timezoneArray as $tz) {

            $entityTimezone = $this->getTimezoneEntity();
            $entityTimezone->setLanguage($langEntity);
            $entityTimezone->setName($tz['name']);
            $entityTimezone->setCountryCode($tz['countryCode']);
            $entityTimezone->setLatitude($tz['latitude']);
            $entityTimezone->setLongitude($tz['longitude']);
            $entityTimezone->setComments($tz['comments']);

            $checkNull = $this->getTimezoneRepository()->findOneBy(array('name' => $tz['name']));
            if (empty($checkNull)) {
                // save it
                $this->_entityManager->persist($entityTimezone);
                $this->_entityManager->flush($entityTimezone);
            }
        }

        return true;
    }

    /**
     * Save user-application-link to database
     *
     * @param \Sso\ApiBundle\Entity\Webservice\Type\UserApplication $entity
     * @return boolean
     */
    public function saveUserApplication(Type\UserApplication $entity)
    {
        // Do default validation
        $entity->setValidator($this->validator);
        if (!$entity->isValid()) {
            return false;
        }

        $this->_entityManager->persist($entity);
        $this->_entityManager->flush($entity);

        return true;
    }

    /**
     *
     * @return ModelTimezone
     */
    public function getTimezoneEntity()
    {

        return new ModelTimezone($this->validator);
    }

    /**
     *
     * @return Sso\Webservices\LocationBundle\Entity\Timezone
     */
    public function getTimezoneRepository()
    {
        return $this->_entityManager->getRepository('Sso\Webservices\LocationBundle\Entity\Timezone');
    }
}