<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\BackendBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;

/**
 * Class ReportingController
 * @package Sso\BackendBundle\Controller
 */
class ReportingController extends WsAbstractController
{
    /**
     * @Route("/hierarchy/objects", name="_admin_backend_webservice_reporting_objects")
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function objectsAction()
    {
        $types = $this->databaseManager()->webservice()->types()->getTypeRepository()->findBy(
            array(),
            array('typeOrder' => 'ASC')
        );
        return $this->render('@SsoBackend/reporting/objects.html.twig', ['types' => $types]);
    }

}
