<?php

/**
 * @class TokenFilterType
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\Extension\Core\Type as FormType;

/**
 * Class TokenFilterType
 * @package Sso\BackendBundle\Form
 */
class TokenFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('ServiceToken', FormType\TextType::class)
            ->add('ServiceToken2Ip', FormType\TextType::class)
            ->add('AllowedCallsPerDay', FormType\TextType::class)
            ->add('ValidUntil', FormType\TextType::class)
            ->add('Blocked', FormType\TextType::class);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_tokenfiltertype';
    }
}
