<?php

/**
 * Class TypeMappingFilterType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\Extension\Core\Type as FormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

/**
 * Class TypeMappingFilterType
 * @package Sso\BackendBundle\Form
 */
class TypeMappingFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('identifier', FormType\TextType::class)
            ->add('typeName', FormType\TextType::class)
            ->add('typeId', EntityType::class, [
                'class' => \Sso\Webservices\ObjectBundle\Entity\Type::class,
            ]);
    }

    /**
     * @param mixed $data
     * @return boolean
     */
    private function isEmpty($data)
    {
        if (is_array($data)) {
            foreach ($data as $value) {
                if (!$this->isEmpty($value)) {
                    return false;
                }
            }
            return true;
        }
        return empty($data);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_typemappingfiltertype';
    }
}
