<?php

/**
 * @class WsObjectValuesType
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\BackendBundle\Form;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class WsObjectValuesType
 * @package Sso\BackendBundle\Form
 */
class WsObjectValuesType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('object', EntityType::class, [
                'class' => 'Sso\Webservices\ObjectBundle\Entity\Object',
                'choice_label' => 'name',
                'label' => 'Object',
                'disabled' => true
            ])
            ->add('value')
            ->add('language', EntityType::class, [
                'class' => 'Sso\Webservices\ObjectBundle\Entity\Language',
                'choice_label' => 'name',
                'required' => true,
                'label' => 'Language'
            ]);
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue'
        ]);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_object';
    }
}
