<?php

/**
 * @class WsLocationFilterType
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\Extension\Core\Type as FormType;

/**
 * Class WsTypeFilterType
 * @package Sso\BackendBundle\Form
 */
class WsTypeFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('id', FormType\TextType::class)
            ->add('name', FormType\TextType::class);

        $listener = function (FormEvent $event) {

            // Is data empty?
            if ($this->isEmpty($event->getData())) {
                $event->getForm()->addError(new FormError('Filter empty'));
            }
        };
        $builder->addEventListener(FormEvents::POST_SUBMIT, $listener);
    }

    /**
     * @param mixed $data
     * @return boolean
     */
    private function isEmpty($data)
    {
        if (is_array($data)) {
            foreach ($data as $value) {
                if (!$this->isEmpty($value)) {
                    return false;
                }
            }
            return true;
        }
        return empty($data);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_webservicetypesfiltertype';
    }
}
