<?php

/**
 * Class ObjectController
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Sso\DemoBundle\Controller\BaseController;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\Form\Extension\Core\Type as FormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

/**
 * Class ObjectController
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package     Sso\DemoBundle\Controller
 */
class ObjectController extends BaseController
{

    /**
     * @Route("/", name="_sso_demo_object_show_single")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function showSingleAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Guid', EntityType::class, array(
                'class' => 'SsoWebservicesObjectBundle:Object',
                'choice_label' => 'Guid',
                'required' => false,
            ))
            ->add('ReferenceId', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('Offset', FormType\IntegerType::class, array(
                'required' => false,
            ))
            ->add('Limit', FormType\IntegerType::class, array(
                'required' => false,
            ))
            ->add('LanguageCode', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Object', 'ShowSingle');
    }

    /**
     * @Route("/", name="_sso_demo_object_show_multi")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function showMultiAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Type', EntityType::class, array(
                'class' => 'SsoWebservicesObjectBundle:TypeMapping',
                'choice_label' => 'Identifier',
                'required' => false,
            ))
            ->add('Guid', EntityType::class, array(
                'class' => 'SsoWebservicesObjectBundle:Object',
                'choice_label' => 'Guid',
                'required' => false,
            ))
            ->add('ReferenceId', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('Offset', FormType\IntegerType::class, array(
                'required' => false,
            ))
            ->add('Limit', FormType\IntegerType::class, array(
                'required' => false,
            ))
            ->add('LanguageCode', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Object', 'ShowMulti');
    }

    /**
     * @Route("/", name="_sso_demo_object_tree_view")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function treeViewAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Guid', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('ReferenceId', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('Offset', FormType\IntegerType::class, array(
                'required' => false,
            ))
            ->add('Limit', FormType\IntegerType::class, array(
                'required' => false,
            ))
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Object', 'TreeView');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectShowSingle($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Object>
                            <ShowSingle>
                                <ObjectType>
                                    " . $this->xmlBuildObjectShowIdentifier($params) . "
                                </ObjectType>
                            </ShowSingle>
                        </Object>
                    </SsoRequest>";
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectShowMulti($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Object>
                            <ShowMulti>
                                <ObjectType>
                                    " . $this->xmlBuildObjectShowIdentifier($params) . "
                                </ObjectType>
                            </ShowMulti>
                        </Object>
                    </SsoRequest>";
    }


    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectTreeView($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Object>
                            <TreeView>
                                <ObjectType>
                                    " . $this->xmlBuildObjectTreeViewIdentifier($params) . "
                                </ObjectType>
                            </TreeView>
                        </Object>
                    </SsoRequest>";
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildObjectShowIdentifier($params, $prefix = '')
    {
        $keys = ['Type', 'Guid', 'ReferenceId', 'Offset', 'Limit', 'LanguageCode'];
        return $this->xmlBuildIdentifier($keys, $params, $prefix);
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildObjectTreeViewIdentifier($params, $prefix = '')
    {
        $keys = ['(string)Guid', 'ReferenceId', 'Offset', 'Limit'];
        return $this->xmlBuildIdentifier($keys, $params, $prefix);
    }

    /**
     * @Route("/", name="_sso_demo_object_add")
     * @Template()
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('ReferenceId', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('TypeId', EntityType::class, array(
                'class' => 'SsoWebservicesObjectBundle:Type',
                'choice_label' => 'Id',
                'required' => false,
            ))
            ->add('ParentGuid', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('Name', FormType\TextType::class)
            ->add('Active', FormType\TextType::class)
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Object', 'Add');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectAdd($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Object>
                            <Add>
                                <ObjectType>
                                    " . $this->xmlBuildObjectAddIdentifier($params) . "
                                </ObjectType>
                            </Add>
                        </Object>
                    </SsoRequest>";
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildObjectAddIdentifier($params, $prefix = '')
    {
        $keys = ['ReferenceId', 'TypeId', '(string)ParentGuid', 'Name', 'Active'];
        return $this->xmlBuildIdentifier($keys, $params, $prefix);
    }

    /**
     * @Route("/", name="_sso_demo_object_update")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function updateAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Guid', EntityType::class, array(
                'class' => 'SsoWebservicesObjectBundle:Object',
                'choice_label' => 'Guid',
                'required' => false,
            ))
            ->add('ReferenceId', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('TypeId', EntityType::class, array(
                'class' => 'SsoWebservicesObjectBundle:Type',
                'choice_label' => 'Id',
                'required' => false,
            ))
            ->add('ParentGuid', EntityType::class, array(
                'class' => 'SsoWebservicesObjectBundle:Object',
                'choice_label' => 'Guid',
                'required' => false,
            ))
            ->add('Name', FormType\TextType::class)
            ->add('Active', FormType\ChoiceType::class, array(
                'choices' => array('1' => 'true', 'false' => 'false'),
                'required' => false,
            ))
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Object', 'Update');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectUpdate($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Object>
                            <Update>
                                <ObjectType>
                                    " . $this->xmlBuildObjectUpdateIdentifier($params) . "
                                </ObjectType>
                            </Update>
                        </Object>
                    </SsoRequest>";
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildObjectUpdateIdentifier($params, $prefix = '')
    {
        $keys = ['Guid', 'ReferenceId', 'TypeId', 'ParentGuid', 'Name', 'Active'];
        return $this->xmlBuildIdentifier($keys, $params, $prefix);
    }

    /**
     * Build xml to identify type
     *
     * @param array $keys
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildIdentifier($keys, $params, $prefix = '')
    {
        $xml = array();
        foreach ($keys as $key) {
            if (in_array($key, array('Guid', 'ParentGuid'))) {
                $idx = $prefix . $key;
                if (!empty($params[$idx])) {
                    $xml[] = '<' . $key . '>' . $params[$idx]->getGuid() . '</' . $key . '>';
                }
            } elseif (in_array($key, array('(string)Guid'))) {
                $idx = $prefix . 'Guid';
                if (!empty($params[$idx]) || $params[$idx] === 0) {
                    $xml[] = '<Guid>' . $params[$idx] . '</Guid>';
                }
            } elseif (in_array($key, array('(string)ParentGuid'))) {
                $idx = $prefix . 'ParentGuid';
                if (!empty($params[$idx]) || $params[$idx] === 0) {
                    $xml[] = '<ParentGuid>' . $params[$idx] . '</ParentGuid>';
                }
            } elseif ($key == 'TypeId') {
                $idx = $prefix . $key;
                if (!empty($params[$idx])) {
                    $xml[] = '<' . $key . '>' . $params[$idx]->getId() . '</' . $key . '>';
                }
            } elseif ($key == 'Type') {
                $idx = $prefix . $key;
                if (!empty($params[$idx])) {
                    $xml[] = '<' . $key . '>' . $params[$idx]->getIdentifier() . '</' . $key . '>';
                }
            } else {
                $idx = $prefix . $key;
                if (!empty($params[$idx]) || $params[$idx] === 0) {
                    $xml[] = '<' . $key . '>' . $params[$idx] . '</' . $key . '>';
                }
            }
        }
        return implode("\n", $xml);
    }

    /**
     * @Route("/", name="_sso_demo_object_delete")
     * @Template()
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Guid', EntityType::class, array(
                'class' => 'SsoWebservicesObjectBundle:Object',
                'choice_label' => 'Guid',
                'required' => false,
            ))
            ->add('ReferenceId', FormType\TextType::class, array(
                'required' => false,
            ))
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Object', 'Delete');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectDelete($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Object>
                            <Delete>
                                <ObjectType>
                                    " . $this->xmlBuildObjectDeleteIdentifier($params) . "
                                </ObjectType>
                            </Delete>
                        </Object>
                    </SsoRequest>";
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildObjectDeleteIdentifier($params, $prefix = '')
    {
        $keys = ['Guid', 'ReferenceId'];
        return $this->xmlBuildIdentifier($keys, $params, $prefix);
    }
}
