<?php

/**
 * TypeController
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Sso\DemoBundle\Controller\BaseController;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\Form\Extension\Core\Type as FormType;

/**
 * Class TypeController
 * @package Sso\DemoBundle\Controller
 */
class TypeController extends BaseController
{
    /**
     * @Route("/", name="_sso_demo_type_add")
     * @Template()
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Name', FormType\TextType::class)
            ->add('TypeOrder', FormType\TextType::class)
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Type', 'Add');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlTypeAdd($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Type>
                            <Add>
                                <TypeType>
                                    " . $this->_xmlBuildTypeIdentifier($params) . "
                                </TypeType>
                            </Add>
                        </Type>
                    </SsoRequest>";
    }

    /**
     * @Route("/", name="_sso_demo_type_update")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function updateAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Id', FormType\TextType::class)
            ->add('Name', FormType\TextType::class)
            ->add('TypeOrder', FormType\IntegerType::class, array('attr' => array('min' => 1)))
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Type', 'Update');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlTypeUpdate($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Type>
                            <Update>
                                <TypeType>
                                    " . $this->_xmlBuildTypeUpdateIdentifier($params) . "
                                </TypeType>
                            </Update>
                        </Type>
                    </SsoRequest>";
    }

    /**
     * @Route("/", name="_sso_demo_type_show")
     * @Template()
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Id', FormType\TextType::class)
            ->add('Name', FormType\TextType::class)
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Type', 'Show');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlTypeShow($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Type>
                            <Show>
                                <TypeType>
                                    " . $this->_xmlBuildTypeShowIdentifier($params) . "
                                </TypeType>
                            </Show>
                        </Type>
                    </SsoRequest>";
    }

    /**
     * @Route("/", name="_sso_demo_type_delete")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Id', FormType\TextType::class)
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Type', 'Delete');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlTypeDelete($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Type>
                            <Delete>
                                <TypeType>
                                    " . $this->xmlBuildTypeDeleteIdentifier($params) . "
                                </TypeType>
                            </Delete>
                        </Type>
                    </SsoRequest>";
    }
}
