<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\HelpBundle\Tests\Controller;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\BrowserKit\Cookie;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;

/**
 * Class TypeControllerTest
 * @package Sso\HelpBundle\Tests\Controller
 */
class TypeControllerTest extends WebTestCase
{
    /**
     * @var \Symfony\Bundle\FrameworkBundle\Client
     */
    protected $client = null;

    /**
     * Create client
     */
    public function setUp()
    {
        parent::setUp();
        $this->client = static::createClient();
    }

    public function testIndex()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/');
        $this->assertTrue($crawler->filter('html:contains("Sso Webservice")')->count() > 0);
    }

    public function testStringAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/string');
        $this->assertTrue($crawler->filter('html:contains("Data Type String")')->count() > 0);
    }

    public function testBoolAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/bool');
        $this->assertTrue($crawler->filter('html:contains("Data Type Bool")')->count() > 0);
    }

    public function testEmailAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/email');
        $this->assertTrue($crawler->filter('html:contains("Data Type Email")')->count() > 0);
    }

    public function testServiceTokenAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/servicetoken');
        $this->assertTrue($crawler->filter('html:contains("Data Type Service Token")')->count() > 0);
    }

    public function testServiceNameAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/servicename');
        $this->assertTrue($crawler->filter('html:contains("Data Type Service Name")')->count() > 0);
    }

    public function testUserIdentifierAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/useridentifier');
        $this->assertTrue($crawler->filter('html:contains("Data Type Service User Identifier")')->count() > 0);
    }

    public function testServiceCountryCodeAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/servicecountrycode');
        $this->assertTrue($crawler->filter('html:contains("Data Type Service Country Code")')->count() > 0);
    }

    public function testPasswordAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/password');
        $this->assertTrue($crawler->filter('html:contains("Data Type Password")')->count() > 0);
    }

    public function testGuidAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/guid');
        $this->assertTrue($crawler->filter('html:contains("Data Type GUID")')->count() > 0);
    }

    public function testUsernameAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/username');
        $this->assertTrue($crawler->filter('html:contains("Data Type Username")')->count() > 0);
    }

    public function testIdentifierAction()
    {
        $this->logIn();
        $crawler = $this->client->request('GET', '/help/types/identifier');
        $this->assertTrue($crawler->filter('html:contains("Data Type Identifier")')->count() > 0);
    }

    /**
     * Simulate login
     */
    private function logIn()
    {
        $session = $this->client->getContainer()->get('session');

        $firewall = $this->getFirewall();
        $token = new UsernamePasswordToken('unittest', null, $firewall, array('ROLE_SUPER_ADMIN'));
        $session->set('_security_' . $firewall, serialize($token));
        $session->save();

        $cookie = new Cookie($session->getName(), $session->getId());
        $this->client->getCookieJar()->set($cookie);
    }

    /**
     * Get firewall name @see security.yml
     *
     * @return string
     */
    private function getFirewall()
    {
        return 'main';
    }
}
