<?php

/**
 * Steps ServiceTrigger
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps ServiceTrigger
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class ServiceTrigger
{

    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @var string
     */
    private $UserIdentifier;

    /**
     *
     * @param string $UserIdentifier
     * @return ServiceTrigger
     */
    public function setUserIdentifier($UserIdentifier)
    {
        $this->UserIdentifier = (string)$UserIdentifier;

        return $this;
    }

    /**
     *
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->UserIdentifier;
    }

}