<?php

/**
 * Steps GetAction
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Request\UserIdentifier;

use JMS\Serializer\Annotation as Serializer;
use Sso\Tools\UserIdentifierBundle\Model\Request\Node;

/**
 * Steps GetAction
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Get
{
    /**
     * @Serializer\Exclude()
     * @var Node\Factory
     */
    private $nodeFactory;

    /**
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\Node\Key")
     * @var Node\Key
     */
    private $key;

    /**
     *
     * @param Node\Factory $nodeFactory
     */
    public function __construct(Node\Factory $nodeFactory)
    {
        $this->nodeFactory = $nodeFactory;
    }

    /**
     * @return Node\Key
     */
    public function key()
    {
        return null !== $this->key ? $this->key : ($this->key = $this->nodeFactory->key());
    }

}