<?php

/**
 * Steps Get
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Response\UserIdentifier;

use JMS\Serializer\Annotation as Serializer;
use Sso\Tools\UserIdentifierBundle\Model\Response\Node;

/**
 * Steps Get
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Get
{

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Response\Node\UserType")
     * @var Node\UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("Errors")
     * @Serializer\Type("array<Sso\Tools\UserIdentifierBundle\Model\Response\Node\Error>")
     * @var Node\Error[]
     */
    private $errors;

    /**
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     *
     * @return Node\UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     *
     * @return Node\Error[]
     */
    public function getErrors()
    {
        return $this->errors;
    }

}