<?php

/**
 * Class LoadTypeMappings
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Sso\Webservices\ObjectBundle\Entity\TypeMapping;

/**
 * Class LoadTypeMappings
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider
 */
class LoadTypeMappings extends AbstractFixture implements OrderedFixtureInterface
{

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $rows = [
            ['location', 'BB25734E-BFF8-878A-E4F7-B2F0F38142F7'],
        ];


        foreach ($rows as $row) {

            $typeEntity = $this->getReference('type-' . $row[1]);

            $entity = new TypeMapping();
            $entity
                ->setIdentifier($row[0])
                ->setType($typeEntity);

            $manager->persist($entity);
        }

        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 1;
    }

}
