<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Database\Data;

use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;

use Sso\Webservices\ObjectBundle\Database\Data\Attribute;
use Sso\Webservices\ObjectBundle\Database\Data\AttributeValue;
use Sso\Webservices\ObjectBundle\Database\Data\Language;
use Sso\Webservices\ObjectBundle\Database\Data\Object;
use Sso\Webservices\ObjectBundle\Database\Data\ObjectAttributeValue;
use Sso\Webservices\ObjectBundle\Database\Data\Type;
use Sso\Webservices\ObjectBundle\Database\Repository\Factory as RepositoryFactory;

/**
 * Class Factory
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Database\Data
 */
class Factory
{

    /**
     * @var array
     */
    protected $facSetter;

    /**
     * Doctrine Registry
     *
     * @var DoctrineRegistry
     */
    protected $doctrineRegistry;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @param DoctrineRegistry $doctrineRegistry
     * @param RepositoryFactory $repoFactory
     */
    public function __construct(DoctrineRegistry $doctrineRegistry, RepositoryFactory $repoFactory)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->entityManager = $this->doctrineRegistry->getManager('Webservice');
        $this->repositoryFactory = $repoFactory;
    }

    /**
     *
     * @return Attribute\Index
     */
    public function attribute()
    {
        if (!isset($this->facSetter['attribute'])) {
            $this->facSetter['attribute'] = new Attribute\Index($this->doctrineRegistry, $this->repositoryFactory);
        }
        return $this->facSetter['attribute'];
    }

    /**
     *
     * @return AttributeGroup\Index
     */
    public function attributeGroup()
    {
        if (!isset($this->facSetter['attributeGroup'])) {
            $this->facSetter['attributeGroup'] = new AttributeGroup\Index($this->doctrineRegistry,
                $this->repositoryFactory);
        }
        return $this->facSetter['attributeGroup'];
    }

    /**
     *
     * @return Language\Index
     */
    public function language()
    {
        if (!isset($this->facSetter['language'])) {
            $this->facSetter['language'] = new Language\Index($this->doctrineRegistry, $this->repositoryFactory);
        }
        return $this->facSetter['language'];
    }

    /**
     *
     * @return Object\Index
     */
    public function object()
    {
        if (!isset($this->facSetter['object'])) {
            $this->facSetter['object'] = new Object\Index($this->doctrineRegistry, $this->repositoryFactory);
        }
        return $this->facSetter['object'];
    }

    /**
     *
     * @return TreeObject\Index
     */
    public function treeObject()
    {
        if (!isset($this->facSetter['treeObject'])) {
            $this->facSetter['treeObject'] = new TreeObject\Index($this->doctrineRegistry, $this->repositoryFactory);
        }
        return $this->facSetter['treeObject'];
    }

    /**
     *
     * @return ObjectAttributeValue\Index
     */
    public function objectAttributeValue()
    {
        if (!isset($this->facSetter['objectAttributeValue'])) {
            $this->facSetter['objectAttributeValue'] = new ObjectAttributeValue\Index($this->doctrineRegistry,
                $this->repositoryFactory);
        }
        return $this->facSetter['objectAttributeValue'];
    }

    /**
     *
     * @return Type\Index
     */
    public function type()
    {
        if (!isset($this->facSetter['type'])) {
            $this->facSetter['type'] = new Type\Index($this->doctrineRegistry, $this->repositoryFactory);
        }
        return $this->facSetter['type'];
    }

    /**
     *
     * @return TypeMapping\Index
     */
    public function typeMapping()
    {
        if (!isset($this->facSetter['typeMapping'])) {
            $this->facSetter['typeMapping'] = new TypeMapping\Index($this->doctrineRegistry, $this->repositoryFactory);
        }
        return $this->facSetter['typeMapping'];
    }

}
