<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Database\Entity;

use Sso\Webservices\ObjectBundle\Entity;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Database\Entity
 */
class Factory
{

    /**
     * @return Entity\AttributeGroup
     */
    public function attributeGroup()
    {
        return new Entity\AttributeGroup();
    }

    /**
     * @return Entity\Attribute
     */
    public function attribute()
    {
        return new Entity\Attribute();
    }

    /**
     * @return Entity\Language
     */
    public function language()
    {
        return new Entity\Language();
    }

    /**
     * @return Entity\Object
     */
    public function object()
    {
        return new Entity\Object();
    }

    /**
     * @return Entity\ObjectAttributeValue
     */
    public function objectAttributeValue()
    {
        return new Entity\ObjectAttributeValue();
    }

    /**
     * @return Entity\Type
     */
    public function type()
    {
        return new Entity\Type();
    }

    /**
     * @return Entity\TypeMapping
     */
    public function typeMapping()
    {
        return new Entity\TypeMapping();
    }

}
