<?php

namespace Sso\Webservices\ObjectBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * @ORM\Entity
 * @ORM\Table(name="obj_attribute_group",indexes={@Orm\Index(name="attr_name_idx", columns={"name"})})
 * @ORM\HasLifecycleCallbacks()
 */
class AttributeGroup
{
    /**
     * @var string
     *
     * @ORM\Column(name="id", type="uuid", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $id;

    /**
     *
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     *
     * @var string
     *
     * @ORM\Column(name="lower_name", type="string", length=255, nullable=false)
     */
    private $lowerName;

    /**
     *
     * @var Type[]
     *
     * @ORM\ManyToMany(targetEntity="Type",inversedBy="attributeGroups")
     * @ORM\JoinTable(name="obj_type_has_attribute_group",
     *      joinColumns={@ORM\JoinColumn(name="attribute_group_id", referencedColumnName="id")},
     *      inverseJoinColumns={@ORM\JoinColumn(name="type_id", referencedColumnName="id")}
     * )
     */
    private $types;

    /**
     *
     * @var Attribute[]
     *
     * @ORM\OneToMany(targetEntity="Attribute", mappedBy="attributeGroup")
     */
    private $attributes;

    /**
     *
     * ORM Mapping
     * @ORM\Column(name="created", type="datetime", nullable=false)
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $created;

    /**
     *
     * ORM Mapping
     * @ORM\Column(name="updated", type="datetime", nullable=false)
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $updated;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->types = new \Doctrine\Common\Collections\ArrayCollection();
        $this->attributes = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Set id
     *
     * @param string $id
     * @return AttributeGroup
     */
    public function setId($id)
    {
        $this->id = $id instanceof UuidInterface ? $id : Uuid::fromString($id);

        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return (string)$this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return AttributeGroup
     */
    public function setName($name)
    {
        $this->name = $name;
        $this->setLowerName(mb_strtolower($name, 'utf-8'));

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set lowerName
     *
     * @param string $lowerName
     * @return AttributeGroup
     */
    public function setLowerName($lowerName)
    {
        $this->lowerName = $lowerName;

        return $this;
    }

    /**
     * Get lowerName
     *
     * @return string
     */
    public function getLowerName()
    {
        return $this->lowerName;
    }

    /**
     * Add types
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Type $types
     * @return AttributeGroup
     */
    public function addType(\Sso\Webservices\ObjectBundle\Entity\Type $types)
    {
        $this->types[] = $types;

        return $this;
    }

    /**
     * Remove types
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Type $types
     */
    public function removeType(\Sso\Webservices\ObjectBundle\Entity\Type $types)
    {
        $this->types->removeElement($types);
    }

    /**
     * Get types
     *
     * @return Type[]
     */
    public function getTypes()
    {
        return $this->types;
    }

    /**
     * @param string $id
     * @return bool
     */
    public function hasType($id)
    {
        $types = $this->getTypes();

        foreach ($types as $type) {
            if ($type->getId() == $id) {
                return true;
            }
        }

        return false;
    }

    /**
     * Add attributes
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Attribute $attributes
     * @return AttributeGroup
     */
    public function addAttribute(\Sso\Webservices\ObjectBundle\Entity\Attribute $attributes)
    {
        $this->attributes[] = $attributes;

        return $this;
    }

    /**
     * Remove attributes
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Attribute $attributes
     */
    public function removeAttribute(\Sso\Webservices\ObjectBundle\Entity\Attribute $attributes)
    {
        $this->attributes->removeElement($attributes);
    }

    /**
     * Get attributes
     *
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Set created
     *
     * @ORM\PrePersist
     *
     * @return AttributeGroup
     */
    public function setCreatedAt()
    {
        $this->created = new \DateTime();
        $this->updated = new \DateTime();

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @ORM\PreUpdate
     *
     * @return AttributeGroup
     */
    public function setUpdated()
    {
        $this->updated = new \DateTime();

        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }
}
