<?php

namespace Sso\Webservices\ObjectBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * @ORM\Entity
 * @ORM\Table(name="obj_object_attribute_value")
 * @ORM\HasLifecycleCallbacks()
 */
class ObjectAttributeValue
{

    /**
     * @var string
     *
     * @ORM\Column(name="id", type="uuid", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $id;

    /**
     * @var Object
     *
     * @ORM\ManyToOne(targetEntity="Object", inversedBy="attributeValues",cascade={"persist"})
     * @ORM\JoinColumn(name="object_guid", referencedColumnName="guid", nullable=false, onDelete="CASCADE")
     */
    private $object;

    /**
     * @var Attribute
     *
     * @ORM\ManyToOne(targetEntity="Attribute", inversedBy="attributeValues")
     * @ORM\JoinColumn(name="attribute_id", referencedColumnName="id", nullable=false)
     */
    private $attribute;

    /**
     *
     * @var string
     *
     * @ORM\Column(name="value", type="string", length=255, nullable=false)
     */
    private $value;

    /**
     *
     * @var Language
     *
     * @ORM\ManyToOne(targetEntity="Language")
     * @ORM\JoinColumn(name="language_id", referencedColumnName="id", nullable=false)
     */
    private $language;

    /**
     *
     * ORM Mapping
     * @ORM\Column(name="created", type="datetime", nullable=false)
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $created;

    /**
     *
     * ORM Mapping
     * @ORM\Column(name="updated", type="datetime", nullable=false)
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $updated;

    /**
     * ObjectAttributeValue constructor.
     */
    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * Set id
     *
     * @param string $id
     * @return ObjectAttributeValue
     */
    public function setId($id)
    {
        $this->id = $id instanceof UuidInterface ? $id : Uuid::fromString($id);

        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return (string)$this->id;
    }

    /**
     * Set value
     *
     * @param string $value
     * @return ObjectAttributeValue
     */
    public function setValue($value)
    {
        $this->value = $value;

        return $this;
    }

    /**
     * Get value
     *
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Set object
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Object $object
     * @return ObjectAttributeValue
     */
    public function setObject(\Sso\Webservices\ObjectBundle\Entity\Object $object)
    {
        $this->object = $object;

        return $this;
    }

    /**
     * Get object
     *
     * @return \Sso\Webservices\ObjectBundle\Entity\Object
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * Set attribute
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Attribute $attribute
     * @return ObjectAttributeValue
     */
    public function setAttribute(\Sso\Webservices\ObjectBundle\Entity\Attribute $attribute)
    {
        $this->attribute = $attribute;

        return $this;
    }

    /**
     * Get attribute
     *
     * @return \Sso\Webservices\ObjectBundle\Entity\Attribute
     */
    public function getAttribute()
    {
        return $this->attribute;
    }

    /**
     * Set language
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Language $language
     * @return ObjectAttributeValue
     */
    public function setLanguage(\Sso\Webservices\ObjectBundle\Entity\Language $language)
    {
        $this->language = $language;

        return $this;
    }

    /**
     * Get language
     *
     * @return \Sso\Webservices\ObjectBundle\Entity\Language
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * Set created
     *
     * @ORM\PrePersist
     */
    public function setCreatedAt()
    {
        $this->created = new \DateTime();
        $this->updated = new \DateTime();
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @ORM\PreUpdate
     */
    public function setUpdated()
    {
        $this->updated = new \DateTime();
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

}
