<?php

namespace Sso\Webservices\ObjectBundle\Model\Request\Attribute\Add\Entity;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("AttributeType")
 * @Serializer\ExclusionPolicy("all")
 */
class Attribute
{
    /**
     * @Assert\NotBlank(message = "attributeAdd01##Invalid Attribute Name##Attribute Name should not be empty",)
     *
     * @Assert\Length(
     *      min = 3,
     *      max = 200,
     *      minMessage = "attributeAdd02##Invalid Attribute Name##Attribute Name must be at least {{ limit }} characters long",
     *      maxMessage = "attributeAdd02##Invalid Attribute Name##Attribute Name cannot be longer than {{ limit }} characters",
     *      exactMessage = "attributeAdd02##Invalid Attribute Name##Attribute Name should have exactly {{ limit }} characters"
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Mandatory")
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\Accessor(setter="setMandatoryFromString")
     *
     * @var bool
     */
    private $mandatory = false;

    /**
     * @Serializer\SerializedName("PossibleValues")
     * @Serializer\Expose
     * @Serializer\Type("array<string>")
     * @Serializer\XmlList(entry="Value")
     *
     * @var mixed
     */
    private $possibleValues;

    /**
     * @Serializer\SerializedName("DefaultValue")
     * @Serializer\Expose
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $defaultValue;

    /**
     * @Serializer\SerializedName("Translatable")
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\Accessor(setter="setTranslatableFromString")
     *
     * @var bool
     */
    private $translatable = false;

    /**
     * @Serializer\SerializedName("GroupId")
     * @Serializer\Expose
     * @Serializer\Type("string")
     *
     * @Assert\Length(
     *     min = 36,
     *     max = 36,
     *     minMessage = "attributeAdd00##Invalid id##Your id must be {{ limit }} characters long",
     *     maxMessage = "attributeAdd00##Invalid id##Your id must be {{ limit }} characters long",
     *     exactMessage = "attributeAdd00##Invalid id##Your id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    private $attributeGroupId;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Attribute
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get mandatory
     *
     * @return bool
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }

    /**
     * Set mandatory from string
     *
     * @param string $mandatory
     * @return Attribute
     */
    public function setMandatoryFromString($mandatory)
    {
        $this->mandatory = '1' === $mandatory;

        return $this;
    }

    /**
     * @return array
     */
    public function getPossibleValues()
    {
        $returnPossibleValues = $this->possibleValues;
        if (!is_array($this->possibleValues)) {
            $returnPossibleValues = explode('/', $this->possibleValues);
        }

        return $returnPossibleValues;
    }

    /**
     * @param mixed $possibleValues
     * @return Attribute
     */
    public function setPossibleValues($possibleValues)
    {
        if (!is_array($possibleValues)) {
            $possibleValues = explode('/', $possibleValues);
        }

        $this->possibleValues = $possibleValues;

        return $this;
    }

    /**
     * @return string
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }

    /**
     * @param string $defaultValue
     * @return Attribute
     */
    public function setDefaultValue($defaultValue)
    {
        $this->defaultValue = $defaultValue;

        return $this;
    }

    /**
     * Get translatable
     *
     * @return bool
     */
    public function getTranslatable()
    {
        return $this->translatable;
    }

    /**
     * Set translatable from string
     *
     * @param string $translatable
     * @return Attribute
     */
    public function setTranslatableFromString($translatable)
    {
        $this->translatable = '1' === $translatable;

        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param string $attributeGroupId
     * @return Attribute
     */
    public function setAttributeGroupId($attributeGroupId)
    {
        $this->attributeGroupId = $attributeGroupId;

        return $this;
    }
}
