<?php

/**
 * Class Attribute
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\Attribute\Delete;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Attribute
 *
 * @Serializer\XmlRoot("AttributeType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @package Sso\Webservices\ObjectBundle\Model\Request\Attribute\Delete\Entity
 */
class Attribute
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @Assert\NotBlank(message = "attributeDelete00##Invalid id##Attribute Id should not be empty",)
     *
     * @Assert\Length(
     *     min = 36,
     *     max = 36,
     *     minMessage = "attributeDelete00##Invalid id##Your id must be {{ limit }} characters long",
     *     maxMessage = "attributeDelete00##Invalid id##Your id must be {{ limit }} characters long",
     *     exactMessage = "attributeDelete00##Invalid id##Your id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    public $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("DeleteReferences")
     *
     * @var bool
     */
    private $deleteReferences = false;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return Attribute
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isDeleteReferences()
    {
        return $this->deleteReferences;
    }

    /**
     * @param boolean $deleteReferences
     * @return Attribute
     */
    public function setDeleteReferences($deleteReferences)
    {
        $this->deleteReferences = $deleteReferences;

        return $this;
    }

}
