<?php

/**
 * Class Attribute
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\Attribute\Show\Entity;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Attribute
 *
 * @Serializer\XmlRoot("AttributeType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @package Sso\Webservices\ObjectBundle\Model\Request\Attribute\Show\Entity
 */
class Attribute
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @Assert\Length(
     *     min = 36,
     *     max = 36,
     *     minMessage = "attributeShow01##Invalid id##Your id must be {{ limit }} characters long",
     *     maxMessage = "attributeShow01##Invalid id##Your id must be {{ limit }} characters long",
     *     exactMessage = "attributeShow01##Invalid id##Your id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    public $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("Offset")
     *
     * @Assert\Type(
     *    type="integer",
     *    message="attributeShow03##Invalid offset##Your offset {{ value }} is not a valid {{ type }}."
     * )
     * @Assert\GreaterThanOrEqual(
     *     value = 0,
     *     message = "attributeShow03##Invalid offset##Your offset must be greater than or equal {{ compared_value }}"
     * )
     *
     * @var string
     */
    private $offset;

    /**
     * @Serializer\Expose
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("Limit")
     *
     * @Assert\Range(
     *      min = 1,
     *      max = 1500,
     *      minMessage = "attributeShow04##Invalid limit##Your limit must be at least {{ limit }}.",
     *      maxMessage = "attributeShow04##Invalid limit##Your limit can not be bigger than {{ limit }}."
     * )
     *
     * @var string
     */
    private $limit;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param string $offset
     * @return Attribute
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
        return $this;
    }

    /**
     * @return string
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param string $limit
     * @return Attribute
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
        return $this;
    }

}
