<?php

/**
 *
 * @class Factory
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Model\Request;

use Sso\Webservices\ObjectBundle\Model\Request\Type\Factory as TypeFactory;
use Sso\Webservices\ObjectBundle\Model\Request\Object\Factory as ObjectFactory;
use Sso\Webservices\ObjectBundle\Model\Request\Language\Factory as LanguageFactory;
use Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Factory as AttributeGroupFactory;
use Sso\Webservices\ObjectBundle\Model\Request\Attribute\Factory as AttributeFactory;
use Sso\Webservices\ObjectBundle\Model\Request\ObjectValue\Factory as ObjectValueFactory;
use Sso\ApiBundle\Api\Manager as ApiManager;

/**
 * Request factory class
 */
class Factory
{

    /**
     * List of factory objects
     *
     * @var array
     */
    protected $factories = array();

    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return \Sso\Webservices\ObjectBundle\Model\Request\Type\Factory
     */
    public function type()
    {
        if (!isset($this->factories['type'])) {
            $this->factories['type'] = new TypeFactory($this->apiM);
        }
        return $this->factories['type'];
    }

    /**
     * @return ObjectFactory
     */
    public function object()
    {
        if (!isset($this->factories['object'])) {
            $this->factories['object'] = new ObjectFactory($this->apiM);
        }
        return $this->factories['object'];
    }

    /**
     * @return ObjectValueFactory
     */
    public function objectValue()
    {
        if (!isset($this->factories['objectValue'])) {
            $this->factories['objectValue'] = new ObjectValueFactory($this->apiM);
        }
        return $this->factories['objectValue'];
    }

    /**
     * @return LanguageFactory
     */
    public function language()
    {
        if (!isset($this->factories['language'])) {
            $this->factories['language'] = new LanguageFactory($this->apiM);
        }
        return $this->factories['language'];
    }

    /**
     * @return AttributeGroupFactory
     */
    public function attributeGroup()
    {
        if (!isset($this->factories['attributeGroup'])) {
            $this->factories['attributeGroup'] = new AttributeGroupFactory($this->apiM);
        }
        return $this->factories['attributeGroup'];
    }

    /**
     * @return AttributeFactory
     */
    public function attribute()
    {
        if (!isset($this->factories['attribute'])) {
            $this->factories['attribute'] = new AttributeFactory($this->apiM);
        }
        return $this->factories['attribute'];
    }
}
