<?php

namespace Sso\Webservices\ObjectBundle\Model\Request\Type\Add;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("TypeType")
 * @Serializer\ExclusionPolicy("all")
 */
class Entity
{

    /**
     * Validation
     *
     * @Assert\NotBlank(message = "typeAdd00##Invalid Name##Name must be at least 3 characters long",)
     *
     * @Assert\Length(
     *      min = 3,
     *      max = 100,
     *      minMessage = "typeAdd01##Invalid Name##Name must be at least {{ limit }} characters long",
     *      maxMessage = "typeAdd01##Invalid Name##Name cannot be longer than {{ limit }} characters"
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * Validation
     * @Assert\Type(
     *     type="integer",
     *     message="typeAdd02##Invalid TypeOrder##The value {{ value }} is not a valid {{ type }}."
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("TypeOrder")
     *
     * @var integer
     *
     */
    private $typeOrder;

    /**
     * Set name
     *
     * @param string $name
     * @return Type
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set order
     *
     * @param integer $typeOrder
     * @return Type
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;

        return $this;
    }

    /**
     * Get typeOrder
     *
     * @return integer
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

}
