<?php

/**
 * Request Type Delete Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\Type\Delete;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("TypeType")
 * @Serializer\ExclusionPolicy("all")
 * @package Sso\Webservices\ObjectBundle\Model\Request\Type\Delete
 */
class Entity
{

    /**
     * Validation
     *
     * @Assert\NotBlank(message = "typeDelete00##Invalid Id##Id must be 36 characters long",)
     *
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "typeDelete00##Invalid Id##Id must be at least {{ limit }} characters long",
     *      maxMessage = "typeDelete00##Invalid Id##Id cannot be longer than {{ limit }} characters",
     *      exactMessage = "typeDelete00##Invalid Id##Id should have exactly {{ limit }} characters"
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     */
    private $id;

    /**
     * Set id
     *
     * @param string $id
     * @return Entity
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

}
