<?php

/**
 * Request Type Update Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\Type\Update;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("TypeType")
 * @Serializer\ExclusionPolicy("all")
 */
class Entity
{

    /**
     * Validation
     *
     * @Assert\NotBlank(message = "typeUpdate00##Invalid Id##Id must be 36 characters long",)
     *
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "typeUpdate00##Invalid Id##Id must be at least {{ limit }} characters long",
     *      maxMessage = "typeUpdate00##Invalid Id##Id cannot be longer than {{ limit }} characters",
     *      exactMessage = "typeUpdate00##Invalid Id##Id should have exactly {{ limit }} characters"
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     */
    private $id;

    /**
     * Validation
     *
     * @Assert\Length(
     *      min = 3,
     *      max = 100,
     *      minMessage = "typeUpdate01##Invalid Name##Name must be at least {{ limit }} characters long",
     *      maxMessage = "typeUpdate01##Invalid Name##Name cannot be longer than {{ limit }} characters"
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * Validation
     *
     * @Assert\Regex(
     *     pattern="/^[1-9]\d*$/",
     *     message="typeUpdate02##Invalid TypeOrder##Your type order must be greater than 0."
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("TypeOrder")
     *
     * @var integer
     *
     */
    private $typeOrder;

    /**
     * Set id
     *
     * @param string $id
     * @return Entity
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Entity
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set order
     *
     * @param integer $typeOrder
     * @return Entity
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;

        return $this;
    }

    /**
     * Get typeOrder
     *
     * @return integer
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

}
