<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Attribute;

use Sso\Webservices\ObjectBundle\Entity\Attribute as EntityAttribute;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Model\Request\Attribute\Show\Entity\Attribute as RequestModelShow;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Attribute
 */
class Factory
{
    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param EntityAttribute $requestModel
     */
    public function add(EntityAttribute $requestModel)
    {
        $model = new Add\Add($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @param EntityAttribute[] $attributeEntities
     * @param int $attributesCount
     * @param RequestModelShow $requestModel
     */
    public function show($attributeEntities, $attributesCount, RequestModelShow $requestModel)
    {
        $model = new Show\Show($this->apiM);
        $model->init($attributeEntities, $attributesCount, $requestModel);
        $model->createResponse();
    }

    /**
     * @param EntityAttribute $requestModel
     */
    public function update($requestModel)
    {
        $model = new Update\Update($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @param EntityAttribute $requestModel
     */
    public function delete($requestModel)
    {
        $model = new Delete\Delete($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

}