<?php

/**
 * Class Update
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Attribute\Update;

use Sso\Webservices\ObjectBundle\Model\Response\Attribute\Base as AttributeGroupBase;
use Sso\Webservices\ObjectBundle\Model\Response\Attribute\Update\Attribute as ResponseObject;
use Sso\Webservices\ObjectBundle\Entity\Attribute as EntityAttribute;

/**
 * Class Update
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Attribute\Show
 */
class Update extends AttributeGroupBase
{
    /**
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     * @var EntityAttribute
     */
    protected $attributeModel;

    /**
     * @param EntityAttribute $attributeModel
     */
    public function init(EntityAttribute $attributeModel)
    {
        //ok first set the db entity
        $this->attributeModel = $attributeModel;
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->attributeModel ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->attributeModel ? false : 'attributeEntity data not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;

        if ($this->attributeModel) {

            $modelOut = $this->apiM->mapper()->modelInToModelOut($this->attributeModel, new ResponseObject());
            $modelOut->setAttributeGroupId($this->attributeModel->getAttributeGroup()->getId());

            $document = $this->apiM->responsebuilder()->document();
            $docFragment = $document->createDocumentFragment();
            $docFragment->appendXML(
                preg_replace('/^\<?[^\>]*\>\s*/', '', $this->apiM->serializer()->serialize($modelOut, 'xml'))
            );
            $xmlContainer->appendChild($docFragment);
        }
    }
}
