<?php

namespace Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Add\Entity;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Serializer\XmlRoot("AttributeGroupType")
 * @Serializer\ExclusionPolicy("all")
 */
class AttributeGroup
{
    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Types")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Add\Entity\Type>")
     * @Serializer\XmlList(entry="Type")
     */
    private $type;

    public function __construct()
    {
        $this->type = new ArrayCollection();
    }

    /**
     * Set id
     *
     * @param string $id
     * @return AttributeGroup
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Get name
     *
     * @return string
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get name
     *
     * @return Type[]
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param Type $type
     * @return AttributeGroup
     */
    public function addType(Type $type)
    {
        $this->type[] = $type;
        return $this;
    }

}
