<?php

/**
 *
 * @class Factory
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup;

use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Add;
use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show;
use Sso\Webservices\ObjectBundle\Entity\AttributeGroup as EntityAttributeGroup;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Show\Entity\AttributeGroup as RequestModelShow;

/**
 * Response factory
 */
class Factory
{
    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param EntityAttributeGroup $requestModel
     */
    public function add(EntityAttributeGroup $requestModel)
    {
        $model = new Add\Add($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @param EntityAttributeGroup[] $attrGroupEntities
     * @param int $attributeGroupsCount
     * @param RequestModelShow $requestModel
     */
    public function show($attrGroupEntities, $attributeGroupsCount, RequestModelShow $requestModel)
    {
        $model = new Show\Show($this->apiM);
        $model->init($attrGroupEntities, $attributeGroupsCount, $requestModel);
        $model->createResponse();
    }

    /**
     * @param EntityAttributeGroup $requestModel
     */
    public function update(EntityAttributeGroup $requestModel)
    {
        $model = new Update\Update($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @param EntityAttributeGroup $requestModel
     */
    public function delete(EntityAttributeGroup $requestModel)
    {
        $model = new Delete\Delete($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

}