<?php

/**
 * Class Type
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Update;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Type
 *
 * @Serializer\XmlRoot("Types")
 * @Serializer\ExclusionPolicy("all")
 *
 * @package Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Update
 */
class Type
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\XmlValue()
     *
     * @var string
     */
    private $id;

    /**
     * Get name
     *
     * @param $id
     * @return string
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

}
