<?php

/**
 * Class Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Entity
 *
 * @Serializer\XmlRoot("ObjectType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Object\Add
 */
class Entity
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Guid")
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ReferenceId")
     *
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ParentGuid")
     *
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeId")
     *
     * @var string
     */
    private $typeId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Created")
     *
     * @var \DateTime
     */
    private $created;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Updated")
     *
     * @var \DateTime
     */
    private $updated;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Active")
     *
     * @var string
     */
    private $active;

    /**
     * Set guid
     *
     * @param string $guid
     * @return Entity
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;

        return $this;
    }

    /**
     * @param string $referenceId
     * @return Entity
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * Set parent
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Object $parent
     * @return Entity
     */
    public function setParent(\Sso\Webservices\ObjectBundle\Entity\Object $parent = null)
    {
        $this->parentGuid = null !== $parent ? $parent->getGuid() : null;

        return $this;
    }

    /**
     * Set type
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\Type $type
     * @return Entity
     */
    public function setType(\Sso\Webservices\ObjectBundle\Entity\Type $type)
    {
        $this->typeId = null !== $type ? $type->getId() : null;

        return $this;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Entity
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get created
     *
     * @return Entity
     */
    public function setCreated(\DateTime $created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Set updated
     *
     * @return Entity
     */
    public function setUpdated(\DateTime $updated)
    {
        $this->updated = $updated;

        return $this;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return Entity
     */
    public function setActive($active)
    {
        $this->active = $active ? '1' : '0';

        return $this;
    }

}