<?php

/**
 * Class Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object\ShowMulti;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Sso\ApiBundle\Api\Mapper\Index as Mapper;
use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue as ObjectAttributeValueEntity;

/**
 * Class Entity
 *
 * @Serializer\XmlRoot("ObjectType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Object\ShowMulti
 */
class Entity
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeId")
     *
     * @var string
     */
    private $typeId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeName")
     *
     * @var string
     */
    private $typeName;

    /**
     * @var
     */
    private $parent;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ParentGuid")
     *
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Guid")
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ReferenceId")
     *
     * @var string
     */
    private $referenceId;

    /**
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $lowerName;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeOrder")
     *
     * @var integer
     */
    private $typeOrder;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Created")
     *
     * @var \DateTime
     */
    private $created;

    /**
     *
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Updated")
     *
     * @var \DateTime
     */
    private $updated;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Attributes")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Response\Object\ShowMulti\Attribute>")
     * @Serializer\XmlList(entry="Attribute")
     *
     * @var ArrayCollection
     */
    private $attributes;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Children")
     * @Serializer\XmlList(entry="ObjectType")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Response\Object\ShowMulti\Child>")
     *
     * @var ArrayCollection
     */
    private $children;

    /**
     * @var Mapper
     */
    private $mapper;

    /**
     * @var string
     */
    private $requestedLangCode;

    /**
     * @param Mapper $mapper
     * @param string $requestedLangCode
     */
    public function __construct(Mapper $mapper, $requestedLangCode)
    {
        $this->mapper = $mapper;
        $this->requestedLangCode = $requestedLangCode;

        $this->attributes = new ArrayCollection();
        $this->children = new ArrayCollection();
    }

    /**
     * Set name
     *
     * @param object $parent
     * @return Entity
     */
    public function setParent($parent)
    {
        $this->parent = $parent;
        if ($this->parent != null) {
            $this->setParentGuid($parent->getGuid());
        }
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Set name
     *
     * @param string $parentGuid
     * @return Entity
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * Set $guid
     *
     * @param string $guid
     * @return Entity
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;

        return $this;
    }

    /**
     * Get guid
     *
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return Entity
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Entity
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set children
     *
     * @param ObjectEntity[] $children
     * @return Entity
     */
    public function setChildren($children)
    {
        $this->children = new ArrayCollection();
        foreach ($children as $child) {
            $this->children[] = $this->mapper->modelInToModelOut($child,
                new Child($this->mapper, $this->requestedLangCode));
        }

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * Set lowerName
     *
     * @param string $lowerName
     * @return Entity
     */
    public function setLowerName($lowerName)
    {
        $this->lowerName = $lowerName;

        return $this;
    }

    /**
     * Get lowerName
     *
     * @return string
     */
    public function getLowerName()
    {
        return $this->lowerName;
    }

    /**
     * Set order
     *
     * @param integer $typeOrder
     * @return Entity
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;

        return $this;
    }

    /**
     * Get typeOrder
     *
     * @return integer
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function setCreated(\DateTime $created)
    {
        $this->created = $created;
        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     */
    public function setUpdated()
    {
        $this->updated = new \DateTime();
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param ObjectAttributeValueEntity[] $attributeValues
     * @return Entity
     */
    public function setAttributeValues($attributeValues)
    {
        foreach ($attributeValues as $attributeValue) {

            // Show only attributes for requested language code
            if (null != $this->requestedLangCode && $this->requestedLangCode != $attributeValue->getLanguage()->getId()) {
                continue;
            }

            $attributeItem = new Attribute();
            $attributeItem->setName($attributeValue->getAttribute()->getName())
                ->setValue($attributeValue->getValue())
                ->setGroupName($attributeValue->getAttribute()->getAttributeGroup()->getName())
                ->setLanguageCode($attributeValue->getLanguage()->getId());
            $this->addAttribute($attributeItem);
        }

        return $this;
    }

    /**
     * Get attributes
     *
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param Attribute $attribute
     * @return $this
     */
    public function addAttribute(Attribute $attribute)
    {
        $this->attributes[] = $attribute;

        return $this;
    }

    /**
     * @return string
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * @param string $typeId
     * @return Entity
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getTypeName()
    {
        return $this->typeName;
    }

    /**
     * @param mixed $typeName
     */
    public function setTypeName($typeName)
    {
        $this->typeName = $typeName;
    }

}
