<?php

/**
 * Class Attribute
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object\ShowSingle;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Attribute
 *
 * @Serializer\XmlRoot("Attributes")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Object\ShowSingle
 */
class Attribute
{
    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("GroupId")
     *
     * @var string
     */
    private $groupId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("GroupName")
     *
     * @var string
     */
    private $groupName;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AttributeId")
     *
     * @var string
     */
    private $attributeId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AttributeName")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AttributeValueId")
     *
     * @var string
     */
    private $valueId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AttributeValue")
     *
     * @var string
     */
    private $value;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Mandatory")
     *
     * @var string
     */
    private $mandatory;

    /**
     * @Serializer\Expose
     * @Serializer\Type("array")
     * @Serializer\SerializedName("PossibleValues")
     * @Serializer\XmlList(entry="Value")
     *
     * @var array
     */
    private $possibleValues;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("DefaultValue")
     *
     * @var string
     */
    private $defaultValue;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Translatable")
     *
     * @var string
     */
    private $translatable;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LanguageCode")
     *
     * @var string
     */
    private $languageCode;

    /**
     * @return string
     */
    public function getGroupId()
    {
        return $this->groupId;
    }

    /**
     * @param string $groupId
     * @return Attribute
     */
    public function setGroupId($groupId)
    {
        $this->groupId = $groupId;

        return $this;
    }

    /**
     * @return string
     */
    public function getGroupName()
    {
        return $this->groupName;
    }

    /**
     * @param string $groupName
     * @return Attribute
     */
    public function setGroupName($groupName)
    {
        $this->groupName = $groupName;

        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param string $attributeId
     * @return Attribute
     */
    public function setAttributeId($attributeId)
    {
        $this->attributeId = $attributeId;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Attribute
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return Attribute
     */
    public function setValue($value)
    {
        $this->value = $value;

        return $this;
    }

    /**
     * @return string
     */
    public function getValueId()
    {
        return $this->valueId;
    }

    /**
     * @param string $valueId
     * @return Attribute
     */
    public function setValueId($valueId)
    {
        $this->valueId = $valueId;

        return $this;
    }

    /**
     * @return string
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }

    /**
     * @param string $mandatory
     * @return Attribute
     */
    public function setMandatory($mandatory)
    {
        $this->mandatory = $mandatory ? '1' : '0';

        return $this;
    }

    /**
     * @return array
     */
    public function getPossibleValues()
    {
        return $this->possibleValues;
    }

    /**
     * @param array $possibleValues
     * @return Attribute
     */
    public function setPossibleValues($possibleValues)
    {
        $this->possibleValues = $possibleValues;

        return $this;
    }

    /**
     * @return string
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }

    /**
     * @param string $defaultValue
     * @return Attribute
     */
    public function setDefaultValue($defaultValue)
    {
        $this->defaultValue = $defaultValue;

        return $this;
    }

    /**
     * @return string
     */
    public function getTranslatable()
    {
        return $this->translatable;
    }

    /**
     * @param string $translatable
     * @return Attribute
     */
    public function setTranslatable($translatable)
    {
        $this->translatable = $translatable ? '1' : '0';

        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     * @return Attribute
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;

        return $this;
    }
}
