<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\ObjectValue;

use Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Add;
use Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Show;
use Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Update;
use Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Delete;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue as EntityObjectValue;
use Sso\Webservices\ObjectBundle\Model\Request\ObjectValue\Show\Entity as RequestEntity;
use Sso\Webservices\ObjectBundle\Model\Request\ObjectValue\Update\Entity as RequestEntityUpdate;
use Sso\Webservices\ObjectBundle\Model\Request\ObjectValue\Delete\Entity as RequestEntityDelete;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\ObjectValue
 */
class Factory
{
    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param EntityObjectValue $requestModel
     */
    public function add(EntityObjectValue $requestModel)
    {
        $model = new Add\Add($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     *
     * @param EntityObjectValue[] $requestModel
     * @param RequestEntity $helperModel
     * @param int $objectValueCount
     */
    public function show($requestModel, $helperModel, $objectValueCount)
    {
        $model = new Show\Show($this->apiM);
        $model->init($requestModel, $helperModel, $objectValueCount);
        $model->createResponse();
    }

    /**
     * @param EntityObjectValue $requestModel
     * @param RequestEntityUpdate $helperModel
     */
    public function update(EntityObjectValue $requestModel, RequestEntityUpdate $helperModel)
    {
        $model = new Update\Update($this->apiM);
        $model->init($requestModel, $helperModel);
        $model->createResponse();
    }

    /**
     * @param EntityObjectValue $requestModel
     * @param RequestEntityDelete $helperModel
     */
    public function delete(EntityObjectValue $requestModel, RequestEntityDelete $helperModel)
    {
        $model = new Delete\Delete($this->apiM);
        $model->init($requestModel, $helperModel);
        $model->createResponse();
    }
}