<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Show;

use Sso\Webservices\ObjectBundle\Model\Response\Type\Base as TypeBase;
use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue as ObjectAttributeValueEntity;
use Sso\Webservices\ObjectBundle\Model\Request\ObjectValue\Show\Entity as RequestEntity;
use Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Show\Entity as ResponseObjectValue;
use LifeStyle\Tools\WebserviceBundle\Error\Type\External as ExternalError;

/**
 * Class Show
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Show
 */
class Show extends TypeBase
{

    /**
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     *
     * @var ObjectAttributeValueEntity[]
     */
    protected $objectValueEntities;

    /**
     *
     * @var RequestEntity
     */
    protected $helperModel;

    /**
     * @var int
     */
    protected $objectValueCount;

    /**
     *
     * @param ObjectAttributeValueEntity[] $objectValueEntities
     * @param RequestEntity $helperModel
     * @param int $objectValueCount
     */
    public function init($objectValueEntities, $helperModel, $objectValueCount)
    {
        //ok first set the db entity
        $this->objectValueEntities = $objectValueEntities;
        $this->helperModel = $helperModel;
        $this->objectValueCount = $objectValueCount;
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->objectValueEntities ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->objectValueEntities ? false : 'ObjectValue not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;

        if ($this->objectValueEntities) {

            $this->apiM->responseBuilder()->addCount($this->objectValueCount);
            $document = $this->apiM->responseBuilder()->document();

            foreach ($this->objectValueEntities as $objectValue) {
                /**
                 * @var ResponseObjectValue $modelOut
                 */
                $modelOut = $this->apiM->mapper()->modelInToModelOut($objectValue, new ResponseObjectValue());
                $modelOut->setAttributeId($objectValue->getAttribute()->getId())
                    ->setAttributeName($objectValue->getAttribute()->getName())
                    ->setLanguageCode($objectValue->getLanguage()->getId())
                    ->setObjectGuid($objectValue->getObject()->getGuid())
                    ->setObjectName($objectValue->getObject()->getName());

                $docFragment = $document->createDocumentFragment();
                $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '',
                    $this->apiM->serializer()->serialize($modelOut, 'xml')));

                $xmlContainer->appendChild($docFragment);
            }
        } else {
            $this->apiM->errors()->clearErrors();
            $this->apiM->errors()->addError(new ExternalError('os001', 'No object values found.',
                'No object values found.', 'No object values found for given id.'));
        }
    }

}
