<?php

/**
 * Response Type Update Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Type\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("TypeType")
 * @Serializer\ExclusionPolicy("all")
 */
class Entity
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     *
     */
    private $id;

    /**
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     *
     */
    private $name;

    /**
     *
     * @var string
     *
     */
    private $lowerName;

    /**
     * @Serializer\Expose
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("TypeOrder")
     *
     * @var integer
     */
    private $typeOrder;

    /**
     *
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Created")
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $created;

    /**
     *
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Updated")
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $updated;


    /**
     * Set id
     *
     * @param string $id
     * @return Entity
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Entity
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set lowerName
     *
     * @param string $lowerName
     * @return Entity
     */
    public function setLowerName($lowerName)
    {
        $this->lowerName = $lowerName;

        return $this;
    }

    /**
     * Get lowerName
     *
     * @return string
     */
    public function getLowerName()
    {
        return $this->lowerName;
    }

    /**
     * Set order
     *
     * @param integer $typeOrder
     * @return Entity
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;

        return $this;
    }

    /**
     * Get typeOrder
     *
     * @return integer
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

    /**
     * Get created
     *
     * @return Entity
     */
    public function setCreated(\DateTime $created)
    {
        $this->created = $created;
        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @return Entity
     */
    public function setUpdated()
    {
        $this->updated = new \DateTime();

        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

}
