<?php

/**
 * Class AttributeGroupControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Doctrine\Common\DataFixtures\Executor\ORMExecutor;
use Doctrine\Common\DataFixtures\Loader;
use Doctrine\Common\DataFixtures\Purger\ORMPurger;
use Guzzle\Service\Client;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServiceNames;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServiceNames2Services;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServices;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadTokens;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadTokens2ServiceNames;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class AttributeGroupControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class AttributeGroupControllerTest extends ControllerTestCase
{

    /**
     * @var WorkerFactory
     */
    protected $worker;

    protected function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');

        $this->worker = new WorkerFactory($this->apiM());
    }

    public function testWorkerAttributeGroupShowAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <AttributeGroup>
                                <Show>
                                    <AttributeGroupType>
                                    </AttributeGroupType>
                                </Show>
                            </AttributeGroup>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attributeGroup()->show($xml->AttributeGroup->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $expectedBag = [
            '1b9badbf-0dd7-af27-842a-ced56dd773b5' => 'UnitTestAttributeGroupOne',
            'b3ab16cb-8e3d-36d7-33a6-b59a7cd7c49e' => 'UnitTestAttributeGroupTwo',
        ];

        foreach ($responseXml->Unknown->Unknown->AttributeGroupType as $attributeGroup) {
            $this->assertTrue(isset($expectedBag[(string)$attributeGroup->Id]));
            $this->assertEquals($expectedBag[(string)$attributeGroup->Id], $attributeGroup->Name);
        }

        $this->assertEquals('Success', $responseXml->Status);
    }

    public function testWorkerAttributeGroupShowWithOffsetAndLimitSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <AttributeGroup>
                                <Show>
                                    <AttributeGroupType>
                                        <Offset>1</Offset>
                                        <Limit>1</Limit>
                                    </AttributeGroupType>
                                </Show>
                            </AttributeGroup>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attributeGroup()->show($xml->AttributeGroup->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $expectedBag = [
            'b3ab16cb-8e3d-36d7-33a6-b59a7cd7c49e' => 'UnitTestAttributeGroupTwo',
        ];

        $this->assertSame(1, count($responseXml->Unknown->Unknown->AttributeGroupType));
        $attributeGroup = $responseXml->Unknown->Unknown->AttributeGroupType[0];

        $this->assertTrue(isset($expectedBag[(string)$attributeGroup->Id]));
        $this->assertEquals($expectedBag[(string)$attributeGroup->Id], $attributeGroup->Name);

        $this->assertEquals('Success', $responseXml->Status);
    }

    public function testWorkerAttributeGroupShowByIdSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <AttributeGroup>
                                <Show>
                                    <AttributeGroupType>
                                        <Id>1b9badbf-0dd7-af27-842a-ced56dd773b5</Id>
                                    </AttributeGroupType>
                                </Show>
                            </AttributeGroup>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attributeGroup()->show($xml->AttributeGroup->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('1b9badbf-0dd7-af27-842a-ced56dd773b5',
            $responseXml->Unknown->Unknown->AttributeGroupType->Id);
        $this->assertEquals('UnitTestAttributeGroupOne', $responseXml->Unknown->Unknown->AttributeGroupType->Name);
    }

    public function testWorkerAttributeGroupUpdateSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <AttributeGroup>
                                <Update>
                                    <AttributeGroupType>
                                        <Id>1b9badbf-0dd7-af27-842a-ced56dd773b5</Id>
                                        <Name>UnitTestAttributeGroupOneUpdated</Name>
                                        <AddTypes>
                                            <TypeId>e43752bb-e4f7-878a-bff8-b2f0f38142f7</TypeId>
                                        </AddTypes>
                                    </AttributeGroupType>
                                </Update>
                            </AttributeGroup>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attributeGroup()->update($xml->AttributeGroup->Update);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('1b9badbf-0dd7-af27-842a-ced56dd773b5',
            $responseXml->Unknown->Unknown->AttributeGroupType->Id);
        $this->assertEquals('UnitTestAttributeGroupOneUpdated',
            $responseXml->Unknown->Unknown->AttributeGroupType->Name);
        $resultIds = [];
        foreach ($responseXml->Unknown->Unknown->AttributeGroupType->Types->Id as $id) {
            $resultIds[] = (string)$id;
        }
        $this->assertEquals('bb25734e-bff8-878a-e4f7-b2f0f38142f7', $resultIds[0]);
        $this->assertEquals('e43752bb-e4f7-878a-bff8-b2f0f38142f7', $resultIds[1]);
    }

    public function testWorkerAttributeGroupAddSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <AttributeGroup>
                                <Add>
                                    <AttributeGroupType>
                                        <Name>UnitTestAttributeGroupAdd</Name>
                                        <Types>
                                            <Type>
                                                <Id>bb25734e-bff8-878a-e4f7-b2f0f38142f7</Id>
                                            </Type>
                                        </Types>
                                    </AttributeGroupType>
                                </Add>
                            </AttributeGroup>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attributeGroup()->add($xml->AttributeGroup->Add);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());
        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('UnitTestAttributeGroupAdd', $responseXml->Unknown->Unknown->AttributeGroupType->Name);
        $this->assertEquals('bb25734e-bff8-878a-e4f7-b2f0f38142f7',
            $responseXml->Unknown->Unknown->AttributeGroupType->Types->Type->Id);
    }

    public function testWorkerAttributeGroupDeleteWithoutDeletingReferencesFail()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <AttributeGroup>
                                <Delete>
                                    <AttributeGroupType>
                                        <Id>1b9badbf-0dd7-af27-842a-ced56dd773b5</Id>
                                    </AttributeGroupType>
                                </Delete>
                            </AttributeGroup>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attributeGroup()->delete($xml->AttributeGroup->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Failure', $responseXml->Status);
        $this->assertEquals('Can not delete AttributeGroup', $responseXml->Unknown->Unknown->Errors->Error->ErrorCode);
    }

    public function testWorkerAttributeGroupDeleteWithDeletingReferencesSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <AttributeGroup>
                                <Delete>
                                    <AttributeGroupType>
                                        <Id>1b9badbf-0dd7-af27-842a-ced56dd773b5</Id>
                                        <DeleteReferences>true</DeleteReferences>
                                    </AttributeGroupType>
                                </Delete>
                            </AttributeGroup>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attributeGroup()->delete($xml->AttributeGroup->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('1b9badbf-0dd7-af27-842a-ced56dd773b5',
            $responseXml->Unknown->Unknown->AttributeGroupType->Id);
    }

}
