<?php

/**
 * Class ObjectValueControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class ObjectValueControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class ObjectValueControllerTest extends ControllerTestCase
{

    /**
     * @var WorkerFactory
     */
    protected $worker;

    protected function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');

        $this->worker = new WorkerFactory($this->apiM());
    }

    public function testWorkerObjectValueShowAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Show>
                                    <ObjectValueType>
                                    </ObjectValueType>
                                </Show>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->show($xml->ObjectValue->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());
        $expectedBag = [
            '24f07207-4874-7cd2-0a3d-271146ed10f3' => [
                '16fa40fd-5f4b-4937-f53e-f598471aafd8',
                'UnitTestObject1',
                '0c7d874e-a114-bf02-81d4-ec7935c748ca',
                'UnitTestAttributeOne',
                'UnitTestValueEN',
                'en'
            ],
            '201fa2fc-7cf2-4db6-bf50-921c235f6b00' => [
                '16fa40fd-5f4b-4937-f53e-f598471aafd8',
                'UnitTestObject1',
                '0c7d874e-a114-bf02-81d4-ec7935c748ca',
                'UnitTestAttributeOne',
                'UnitTestValueDE',
                'de'
            ],
        ];

        foreach ($responseXml->Unknown->Unknown->ObjectValueType as $objectValue) {
            $this->assertTrue(isset($expectedBag[(string)$objectValue->Id]));
            $this->assertEquals($expectedBag[(string)$objectValue->Id][0], $objectValue->ObjectGuid);
            $this->assertEquals($expectedBag[(string)$objectValue->Id][1], $objectValue->ObjectName);
            $this->assertEquals($expectedBag[(string)$objectValue->Id][2], $objectValue->AttributeId);
            $this->assertEquals($expectedBag[(string)$objectValue->Id][3], $objectValue->AttributeName);
            $this->assertEquals($expectedBag[(string)$objectValue->Id][4], $objectValue->Value);
            $this->assertEquals($expectedBag[(string)$objectValue->Id][5], $objectValue->LanguageCode);
        }

        $this->assertEquals('Success', $responseXml->Status);
    }

    public function testWorkerObjectValueShowByIdSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Show>
                                    <ObjectValueType>
                                        <Id>201fa2fc-7cf2-4db6-bf50-921c235f6b00</Id>
                                    </ObjectValueType>
                                </Show>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->show($xml->ObjectValue->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('201fa2fc-7cf2-4db6-bf50-921c235f6b00',
            $responseXml->Unknown->Unknown->ObjectValueType->Id);
    }

    public function testWorkerObjectValueUpdateSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Update>
                                    <ObjectValueType>
                                        <Id>24f07207-4874-7cd2-0a3d-271146ed10f3</Id>
                                        <Value>test value english</Value>
                                        <LanguageCode>en</LanguageCode>
                                    </ObjectValueType>
                                </Update>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->update($xml->ObjectValue->Update);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('24f07207-4874-7cd2-0a3d-271146ed10f3',
            $responseXml->Unknown->Unknown->ObjectValueType->Id);
    }

    public function testWorkerObjectValueDeleteSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Delete>
                                    <ObjectValueType>
                                        <Id>24f07207-4874-7cd2-0a3d-271146ed10f3</Id>
                                    </ObjectValueType>
                                </Delete>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->update($xml->ObjectValue->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('24f07207-4874-7cd2-0a3d-271146ed10f3',
            $responseXml->Unknown->Unknown->ObjectValueType->Id);
    }
}
