<?php

/**
 *
 * @class Language
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Worker\Object;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use LifeStyle\Tools\WebserviceBundle\Exception\InvalidRecordException;
use Sso\ApiBundle\Api\Manager as ApiManager;

class Index
{

    /**
     * Api Manager
     *
     * @var ApiManager
     */
    private $apiM;

    /**
     *
     * @var WorkerManager
     */
    private $woM;

    /**
     * Constructor
     *
     * @param WorkerFactory $woM
     */
    public function __construct(WorkerFactory $woM)
    {
        $this->woM = $woM;
        $this->apiM = $this->woM->apiM();
    }

    /**
     * showSingle object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function showSingle(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectRequest = $this->woM->modelFactory()->request()->object()->showSingle($xml);
            $this->woM->modelFactory()->response()->object()->showSingle()->show($objectRequest->getObjectModels(),
                $objectRequest->getHelperModel(), $objectRequest->getObjectsCount());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * showMulti object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function showMulti(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectRequest = $this->woM->modelFactory()->request()->object()->showMulti($xml);
            $this->woM->modelFactory()->response()->object()->showMulti()->show($objectRequest->getObjectModels(),
                $objectRequest->getHelperModel(), $objectRequest->getObjectsCount());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * treeView object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function treeView(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectRequest = $this->woM->modelFactory()->request()->object()->treeView($xml);
            $this->woM->modelFactory()->response()->object()->treeView()->show($objectRequest->getObjectModels(),
                $objectRequest->getHelperModel(), $objectRequest->getObjectsCount());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * add object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function add(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectRequest = $this->woM->modelFactory()->request()->object()->add($xml);
            $this->woM->modelFactory()->response()->object()->add($objectRequest->getObjectModel());

        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * update object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function update(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectRequest = $this->woM->modelFactory()->request()->object()->update($xml);
            $this->woM->modelFactory()->response()->object()->update($objectRequest->getObjectModel());

        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * Delete object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function delete(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectRequest = $this->woM->modelFactory()->request()->object()->delete($xml);
            $this->woM->modelFactory()->response()->object()->delete($objectRequest->getObjectModel());

        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }
}
